package jamezo97.clonecraft.network;

import jamezo97.clonecraft.entity.EntitySpawnEgg;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import cpw.mods.fml.relauncher.Side;

public class Handler2UpdateEntitySpawnEgg extends Handler{

	@Value(id = 0)
	ItemStack data;
	
	@Value(id = 1)
	int entityId = -1;
	
	public Handler2UpdateEntitySpawnEgg(){
		
	}
	
	public Handler2UpdateEntitySpawnEgg(ItemStack data, int entityId){
		this.data = data;
		this.entityId = entityId;
	}
	

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(data != null && entityId > -1 && player != null){
			Entity e = player.worldObj.getEntityByID(entityId);
			if(e != null && e instanceof EntitySpawnEgg){
				((EntitySpawnEgg)e).stack = data;
			}
		}
	}

}
